/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.CombiningClass;
import gnu.inet.encoding.Composition;
import gnu.inet.encoding.DecompositionKeys;
import gnu.inet.encoding.DecompositionMappings;

public class NFKC {
    static final int SBase = 44032;
    static final int LBase = 4352;
    static final int VBase = 4449;
    static final int TBase = 4519;
    static final int LCount = 19;
    static final int VCount = 21;
    static final int TCount = 28;
    static final int NCount = 588;
    static final int SCount = 11172;

    public static String normalizeNFKC(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char code = in.charAt(i);
            if (code >= '\uac00' && code <= '\ud7af') {
                out.append(NFKC.decomposeHangul(code));
                continue;
            }
            int index = NFKC.decomposeIndex(code);
            if (index == -1) {
                out.append(code);
                continue;
            }
            out.append(DecompositionMappings.m[index]);
        }
        NFKC.canonicalOrdering(out);
        int last_cc = 0;
        int last_start = 0;
        for (int i = 0; i < out.length(); ++i) {
            char b;
            char a;
            int c;
            int cc = NFKC.combiningClass(out.charAt(i));
            if (i > 0 && (last_cc == 0 || last_cc != cc) && (c = NFKC.compose(a = out.charAt(last_start), b = out.charAt(i))) != -1) {
                out.setCharAt(last_start, (char)c);
                out.deleteCharAt(i);
                if (--i == last_start) {
                    last_cc = 0;
                    continue;
                }
                last_cc = NFKC.combiningClass(out.charAt(i - 1));
                continue;
            }
            if (cc == 0) {
                last_start = i;
            }
            last_cc = cc;
        }
        return out.toString();
    }

    static int decomposeIndex(char c) {
        int start = 0;
        int end = DecompositionKeys.k.length / 2;
        int half;
        int code;
        while (c != (code = DecompositionKeys.k[(half = (start + end) / 2) * 2])) {
            if (half == start) {
                return -1;
            }
            if (c > code) {
                start = half;
                continue;
            }
            end = half;
        }
        return DecompositionKeys.k[half * 2 + 1];
    }

    static int combiningClass(char c) {
        int h2 = c >> 8;
        int l = c & 0xFF;
        int i = CombiningClass.i[h2];
        if (i > -1) {
            return CombiningClass.c[i][l];
        }
        return 0;
    }

    static void canonicalOrdering(StringBuffer in) {
        boolean isOrdered = false;
        while (!isOrdered) {
            isOrdered = true;
            int lastCC = NFKC.combiningClass(in.charAt(0));
            for (int i = 0; i < in.length() - 1; ++i) {
                int nextCC = NFKC.combiningClass(in.charAt(i + 1));
                if (nextCC != 0 && lastCC > nextCC) {
                    for (int j = i + 1; j > 0 && NFKC.combiningClass(in.charAt(j - 1)) > nextCC; --j) {
                        char t2 = in.charAt(j);
                        in.setCharAt(j, in.charAt(j - 1));
                        in.setCharAt(j - 1, t2);
                        isOrdered = false;
                    }
                    nextCC = lastCC;
                }
                lastCC = nextCC;
            }
        }
    }

    static int composeIndex(char a) {
        if (a >> 8 >= Composition.composePage.length) {
            return -1;
        }
        int ap = Composition.composePage[a >> 8];
        if (ap == -1) {
            return -1;
        }
        return Composition.composeData[ap][a & 0xFF];
    }

    static int compose(char a, char b) {
        char[] f;
        int h2 = NFKC.composeHangul(a, b);
        if (h2 != -1) {
            return h2;
        }
        int ai = NFKC.composeIndex(a);
        if (ai >= 181 && ai < 391) {
            if (b == Composition.singleFirst[ai - 181][0]) {
                return Composition.singleFirst[ai - 181][1];
            }
            return -1;
        }
        int bi = NFKC.composeIndex(b);
        if (bi >= 391) {
            if (a == Composition.singleSecond[bi - 391][0]) {
                return Composition.singleSecond[bi - 391][1];
            }
            return -1;
        }
        if (ai >= 0 && ai < 144 && bi >= 144 && bi < 181 && bi - 144 < (f = Composition.multiFirst[ai]).length) {
            char r = f[bi - 144];
            if (r == '\u0000') {
                return -1;
            }
            return r;
        }
        return -1;
    }

    static String decomposeHangul(char s2) {
        int SIndex = s2 - 44032;
        if (SIndex < 0 || SIndex >= 11172) {
            return String.valueOf(s2);
        }
        StringBuffer result = new StringBuffer();
        int L = 4352 + SIndex / 588;
        int V = 4449 + SIndex % 588 / 28;
        int T = 4519 + SIndex % 28;
        result.append((char)L);
        result.append((char)V);
        if (T != 4519) {
            result.append((char)T);
        }
        return result.toString();
    }

    static int composeHangul(char a, char b) {
        int TIndex;
        int VIndex;
        int LIndex = a - 4352;
        if (0 <= LIndex && LIndex < 19 && 0 <= (VIndex = b - 4449) && VIndex < 21) {
            return 44032 + (LIndex * 21 + VIndex) * 28;
        }
        int SIndex = a - 44032;
        if (0 <= SIndex && SIndex < 11172 && SIndex % 28 == 0 && 0 <= (TIndex = b - 4519) && TIndex <= 28) {
            return a + TIndex;
        }
        return -1;
    }
}

