/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.PunycodeException;

public class Punycode {
    static final int TMIN = 1;
    static final int TMAX = 26;
    static final int BASE = 36;
    static final int INITIAL_N = 128;
    static final int INITIAL_BIAS = 72;
    static final int DAMP = 700;
    static final int SKEW = 38;
    static final char DELIMITER = '-';

    public static String encode(String input) throws PunycodeException {
        int n = 128;
        int delta = 0;
        int bias = 72;
        StringBuffer output = new StringBuffer();
        int b = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Punycode.isBasic(c)) continue;
            output.append(c);
            ++b;
        }
        if (b > 0) {
            output.append('-');
        }
        int h2 = b;
        while (h2 < input.length()) {
            int c;
            int m4 = Integer.MAX_VALUE;
            for (int i = 0; i < input.length(); ++i) {
                c = input.charAt(i);
                if (c < n || c >= m4) continue;
                m4 = c;
            }
            if (m4 - n > (Integer.MAX_VALUE - delta) / (h2 + 1)) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            delta += (m4 - n) * (h2 + 1);
            n = m4;
            for (int j = 0; j < input.length(); ++j) {
                int t2;
                c = input.charAt(j);
                if (c < n && 0 == ++delta) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                if (c != n) continue;
                int q = delta;
                int k = 36;
                while (q >= (t2 = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias))) {
                    output.append((char)Punycode.digit2codepoint(t2 + (q - t2) % (36 - t2)));
                    q = (q - t2) / (36 - t2);
                    k += 36;
                }
                output.append((char)Punycode.digit2codepoint(q));
                bias = Punycode.adapt(delta, h2 + 1, h2 == b);
                delta = 0;
                ++h2;
            }
            ++delta;
            ++n;
        }
        return output.toString();
    }

    public static String decode(String input) throws PunycodeException {
        int n = 128;
        int i = 0;
        int bias = 72;
        StringBuffer output = new StringBuffer();
        int d = input.lastIndexOf(45);
        if (d > 0) {
            for (int j = 0; j < d; ++j) {
                char c = input.charAt(j);
                if (!Punycode.isBasic(c)) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                output.append(c);
            }
            ++d;
        } else {
            d = 0;
        }
        while (d < input.length()) {
            int oldi = i;
            int w = 1;
            int k = 36;
            while (true) {
                char c;
                int digit;
                if (d == input.length()) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                if ((digit = Punycode.codepoint2digit(c = input.charAt(d++))) > (Integer.MAX_VALUE - i) / w) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                i += digit * w;
                int t2 = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias);
                if (digit < t2) break;
                w *= 36 - t2;
                k += 36;
            }
            bias = Punycode.adapt(i - oldi, output.length() + 1, oldi == 0);
            if (i / (output.length() + 1) > Integer.MAX_VALUE - n) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            n += i / (output.length() + 1);
            output.insert(i %= output.length() + 1, (char)n);
            ++i;
        }
        return output.toString();
    }

    public static final int adapt(int delta, int numpoints, boolean first) {
        delta = first ? (delta /= 700) : (delta /= 2);
        delta += delta / numpoints;
        int k = 0;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    public static final boolean isBasic(char c) {
        return c < '\u0080';
    }

    public static final int digit2codepoint(int d) throws PunycodeException {
        if (d < 26) {
            return d + 97;
        }
        if (d < 36) {
            return d - 26 + 48;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }

    public static final int codepoint2digit(int c) throws PunycodeException {
        if (c - 48 < 10) {
            return c - 48 + 26;
        }
        if (c - 97 < 26) {
            return c - 97;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }
}

