/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.NFKC;
import gnu.inet.encoding.RFC3454;
import gnu.inet.encoding.StringprepException;

public class Stringprep {
    private static final char[] RFC3920_NODEPREP_PROHIBIT = new char[]{'\"', '&', '\'', '/', ':', '<', '>', '@'};

    public static String nameprep(String input) throws StringprepException, NullPointerException {
        return Stringprep.nameprep(input, false);
    }

    public static String nameprep(String input, boolean allowUnassigned) throws StringprepException, NullPointerException {
        if (input == null) {
            throw new NullPointerException();
        }
        StringBuffer s2 = new StringBuffer(input);
        if (!allowUnassigned && Stringprep.contains(s2, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s2, RFC3454.B1);
        Stringprep.map(s2, RFC3454.B2search, RFC3454.B2replace);
        s2 = new StringBuffer(NFKC.normalizeNFKC(s2.toString()));
        if (Stringprep.contains(s2, RFC3454.C12) || Stringprep.contains(s2, RFC3454.C22) || Stringprep.contains(s2, RFC3454.C3) || Stringprep.contains(s2, RFC3454.C4) || Stringprep.contains(s2, RFC3454.C5) || Stringprep.contains(s2, RFC3454.C6) || Stringprep.contains(s2, RFC3454.C7) || Stringprep.contains(s2, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s2, RFC3454.D1);
        boolean l = Stringprep.contains(s2, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s2.charAt(0), RFC3454.D1) && Stringprep.contains(s2.charAt(s2.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s2.toString();
    }

    public static String nodeprep(String input) throws StringprepException, NullPointerException {
        return Stringprep.nodeprep(input, false);
    }

    public static String nodeprep(String input, boolean allowUnassigned) throws StringprepException, NullPointerException {
        if (input == null) {
            throw new NullPointerException();
        }
        StringBuffer s2 = new StringBuffer(input);
        if (!allowUnassigned && Stringprep.contains(s2, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s2, RFC3454.B1);
        Stringprep.map(s2, RFC3454.B2search, RFC3454.B2replace);
        s2 = new StringBuffer(NFKC.normalizeNFKC(s2.toString()));
        if (Stringprep.contains(s2, RFC3454.C11) || Stringprep.contains(s2, RFC3454.C12) || Stringprep.contains(s2, RFC3454.C21) || Stringprep.contains(s2, RFC3454.C22) || Stringprep.contains(s2, RFC3454.C3) || Stringprep.contains(s2, RFC3454.C4) || Stringprep.contains(s2, RFC3454.C5) || Stringprep.contains(s2, RFC3454.C6) || Stringprep.contains(s2, RFC3454.C7) || Stringprep.contains(s2, RFC3454.C8) || Stringprep.contains(s2, RFC3920_NODEPREP_PROHIBIT)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s2, RFC3454.D1);
        boolean l = Stringprep.contains(s2, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s2.charAt(0), RFC3454.D1) && Stringprep.contains(s2.charAt(s2.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s2.toString();
    }

    public static String resourceprep(String input) throws StringprepException, NullPointerException {
        return Stringprep.resourceprep(input, false);
    }

    public static String resourceprep(String input, boolean allowUnassigned) throws StringprepException, NullPointerException {
        if (input == null) {
            throw new NullPointerException();
        }
        StringBuffer s2 = new StringBuffer(input);
        if (!allowUnassigned && Stringprep.contains(s2, RFC3454.A1)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        Stringprep.filter(s2, RFC3454.B1);
        s2 = new StringBuffer(NFKC.normalizeNFKC(s2.toString()));
        if (Stringprep.contains(s2, RFC3454.C12) || Stringprep.contains(s2, RFC3454.C21) || Stringprep.contains(s2, RFC3454.C22) || Stringprep.contains(s2, RFC3454.C3) || Stringprep.contains(s2, RFC3454.C4) || Stringprep.contains(s2, RFC3454.C5) || Stringprep.contains(s2, RFC3454.C6) || Stringprep.contains(s2, RFC3454.C7) || Stringprep.contains(s2, RFC3454.C8)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean r = Stringprep.contains(s2, RFC3454.D1);
        boolean l = Stringprep.contains(s2, RFC3454.D2);
        if (r && l) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!r || Stringprep.contains(s2.charAt(0), RFC3454.D1) && Stringprep.contains(s2.charAt(s2.length() - 1), RFC3454.D1))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return s2.toString();
    }

    static boolean contains(StringBuffer s2, char[] p) {
        for (int i = 0; i < p.length; ++i) {
            char c = p[i];
            for (int j = 0; j < s2.length(); ++j) {
                if (c != s2.charAt(j)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean contains(StringBuffer s2, char[][] p) {
        for (int i = 0; i < p.length; ++i) {
            char[] r = p[i];
            if (1 == r.length) {
                char c = r[0];
                for (int j = 0; j < s2.length(); ++j) {
                    if (c != s2.charAt(j)) continue;
                    return true;
                }
                continue;
            }
            if (2 != r.length) continue;
            char f = r[0];
            char t2 = r[1];
            for (int j = 0; j < s2.length(); ++j) {
                if (f > s2.charAt(j) || t2 < s2.charAt(j)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean contains(char c, char[][] p) {
        for (int i = 0; i < p.length; ++i) {
            char[] r = p[i];
            if (1 == r.length) {
                if (c != r[0]) continue;
                return true;
            }
            if (2 != r.length) continue;
            char f = r[0];
            char t2 = r[1];
            if (f > c || t2 < c) continue;
            return true;
        }
        return false;
    }

    static void filter(StringBuffer s2, char[] f) {
        for (int i = 0; i < f.length; ++i) {
            char c = f[i];
            int j = 0;
            while (j < s2.length()) {
                if (c == s2.charAt(j)) {
                    s2.deleteCharAt(j);
                    continue;
                }
                ++j;
            }
        }
    }

    static void filter(StringBuffer s2, char[][] f) {
        for (int i = 0; i < f.length; ++i) {
            char[] r = f[i];
            if (1 == r.length) {
                char c = r[0];
                int j = 0;
                while (j < s2.length()) {
                    if (c == s2.charAt(j)) {
                        s2.deleteCharAt(j);
                        continue;
                    }
                    ++j;
                }
                continue;
            }
            if (2 != r.length) continue;
            char from = r[0];
            char to = r[1];
            int j = 0;
            while (j < s2.length()) {
                if (from <= s2.charAt(j) && to >= s2.charAt(j)) {
                    s2.deleteCharAt(j);
                    continue;
                }
                ++j;
            }
        }
    }

    static void map(StringBuffer s2, char[] search, String[] replace) {
        for (int i = 0; i < search.length; ++i) {
            char c = search[i];
            int j = 0;
            while (j < s2.length()) {
                if (c == s2.charAt(j)) {
                    s2.deleteCharAt(j);
                    if (null == replace[i]) continue;
                    s2.insert(j, replace[i]);
                    j += replace[i].length() - 1;
                    continue;
                }
                ++j;
            }
        }
    }
}

