/*
 * Decompiled with CFR 0.152.
 */
package xmpp.cebutils;

import java.io.BufferedReader;
import java.io.Console;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.conscrypt.Conscrypt;
import org.jxmpp.stringprep.libidn.LibIdnXmppStringprep;
import xmpp.cebutils.BackupFileHeader;

public class Main {
    public static final String KEYTYPE = "AES";
    public static final String CIPHERMODE = "AES/GCM/NoPadding";

    public static void main(String ... args) throws Exception {
        String l;
        BackupFileHeader backupFileHeader;
        if (args.length != 1 && args.length != 2) {
            System.err.println("usage:");
            System.err.println("  java -jar xmpp.cebutils.jar [source_ceb_file]");
            System.err.println("       : decrypt source_ceb_file to source_ceb_file.txt");
            System.err.println("");
            System.err.println("  java -jar xmpp.cebutils.jar [source_ceb_file] [txt_file]");
            System.err.println("       : encrypt txt_file using source_ceb_file parameters, to txt_file.ceb");
            System.exit(1);
        }
        String cebFile = args[0];
        String txtFile = null;
        if (args.length == 2) {
            txtFile = args[1];
        }
        File file = new File(cebFile);
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        try {
            backupFileHeader = BackupFileHeader.read(dataInputStream);
        }
        catch (Exception e) {
            System.err.println(file.getAbsolutePath() + " does not seem to be a valid backup file");
            System.exit(1);
            return;
        }
        Console console = System.console();
        String password = new String(console.readPassword("Enter password for " + String.valueOf(backupFileHeader.getJid().asBareJid()) + ": ", new Object[0]));
        Cipher cipher = Cipher.getInstance(CIPHERMODE, Conscrypt.newProvider());
        byte[] key = Main.getKey(password, backupFileHeader.getSalt());
        byte[] iv = backupFileHeader.getIv();
        byte[] salt = backupFileHeader.getSalt();
        System.out.println("salt, iv, [final] key:");
        for (byte b : salt) {
            System.out.printf("%02x", b);
        }
        System.out.printf("\n", new Object[0]);
        for (byte b : iv) {
            System.out.printf("%02x", b);
        }
        System.out.printf("\n", new Object[0]);
        for (byte b : key) {
            System.out.printf("%02x", b);
        }
        System.out.printf("\n", new Object[0]);
        BufferedReader reader = null;
        SecretKeySpec keySpec = new SecretKeySpec(key, KEYTYPE);
        IvParameterSpec ivSpec = new IvParameterSpec(backupFileHeader.getIv());
        try {
            cipher.init(2, (Key)keySpec, ivSpec);
            CipherInputStream cipherInputStream = new CipherInputStream(fileInputStream, cipher);
            GZIPInputStream gzipInputStream = new GZIPInputStream(cipherInputStream);
            reader = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8));
        }
        catch (InvalidAlgorithmParameterException e) {
            System.err.println("Correct backup file");
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("Wrong password or corrupt backup file");
            System.exit(1);
            return;
        }
        OutputStreamWriter outputWriter = null;
        if (txtFile != null) {
            FileInputStream nfileInputStream = new FileInputStream(new File(txtFile));
            DataInputStream ndataInputStream = new DataInputStream(nfileInputStream);
            reader = new BufferedReader(new InputStreamReader((InputStream)ndataInputStream, StandardCharsets.UTF_8));
            File fixedFile = new File(".", txtFile + ".ceb");
            System.out.println("writing encrypted .ceb to " + txtFile + ".ceb");
            FileOutputStream outputStream = new FileOutputStream(fixedFile);
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            backupFileHeader.write(dataOutputStream);
            cipher.init(1, (Key)keySpec, ivSpec);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(dataOutputStream, cipher);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(cipherOutputStream);
            outputWriter = new OutputStreamWriter((OutputStream)gzipOutputStream, StandardCharsets.UTF_8);
        } else {
            File decFile = new File(".", cebFile + ".txt");
            System.out.println("writing decrypted .ceb to " + cebFile + ".txt");
            FileOutputStream outputStream = new FileOutputStream(decFile);
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            outputWriter = new OutputStreamWriter((OutputStream)dataOutputStream, StandardCharsets.UTF_8);
        }
        while ((l = reader.readLine()) != null) {
            outputWriter.write(l + "\n");
        }
        outputWriter.flush();
        outputWriter.close();
    }

    public static byte[] getKey(String password, byte[] salt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            return factory.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 1024, 128)).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LibIdnXmppStringprep.setup();
    }
}

